#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)4e18;
const int MAXN = 1000000 + 5;

ll x[MAXN], h[MAXN];
ll ans[MAXN];
int idx[MAXN];
int st[MAXN];

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    for(int i = 0; i < n; i++) cin >> x[i];
    for(int i = 0; i < n; i++) cin >> h[i];

    for(int i = 0; i < n; i++){
        idx[i] = i;
        ans[i] = INF;
    }

    sort(idx, idx+n, [&](int a, int b){
        return x[a] < x[b];
    });

    /* -------- nearest higher to the left -------- */
    int top = 0;
    for(int k = 0; k < n; k++){
        int i = idx[k];
        while(top && h[st[top-1]] < h[i]) top--;
        if(top){
            int j = st[top-1];
            ll dx = llabs(x[i] - x[j]);
            ll dy = h[j] - h[i];
            ans[i] = min(ans[i], dx*dx + dy*dy);
        }
        st[top++] = i;
    }

    /* -------- nearest higher to the right -------- */
    top = 0;
    for(int k = n-1; k >= 0; k--){
        int i = idx[k];
        while(top && h[st[top-1]] < h[i]) top--;
        if(top){
            int j = st[top-1];
            ll dx = llabs(x[i] - x[j]);
            ll dy = h[j] - h[i];
            ans[i] = min(ans[i], dx*dx + dy*dy);
        }
        st[top++] = i;
    }

    /* -------- ropes -------- */
    for(int k = 0; k+1 < n; k++){
        int i = idx[k];
        int j = idx[k+1];

        ll dx = x[j] - x[i];
        ll maxh = (h[i] + h[j] + dx) / 2;

        if(maxh >= h[i]){
            ll px = x[i] + (h[i] - h[i]);
            ans[i] = min(ans[i], (x[i]-px)*(x[i]-px));
        }
        if(maxh >= h[j]){
            ll px = x[j] - (h[j] - h[j]);
            ans[j] = min(ans[j], (x[j]-px)*(x[j]-px));
        }
    }

    /* -------- output -------- */
    for(int i = 0; i < n; i++){
        if(ans[i] == INF) cout << -1 << "\n";
        else cout << (ll)sqrt((long double)ans[i]) << "\n";
    }
}